﻿Imports GPSConnector.Common

Public Class DeviceInfo
    Private _gpsDeviceData As GPSDeviceData
    Public Property GPSDevice As GPSDevice
    Public Property GPSDeviceData As GPSDeviceData
        Get
            Return _gpsDeviceData
        End Get
        Set(value As GPSDeviceData)
            _gpsDeviceData = value
            Timer = 0
        End Set
    End Property
    Public ReadOnly Property StatusColor() As Color
        Get
            If Timer < My.Settings.YellowColorInterval Then
                Return Color.White
            ElseIf Timer < My.Settings.RedColorInterval Then
                Return Color.Yellow
            Else
                Return Color.Red
            End If
        End Get
    End Property
    Public Property Timer As Integer
    Public ReadOnly Property TimerFormat() As String
        Get
            Dim t As TimeSpan = TimeSpan.FromSeconds(Timer)
            If t.Hours > 0 Then
                Return String.Format("{0:D2}:{1:D2}:{2:D2}", t.Hours, t.Minutes, t.Seconds)
            Else
                Return String.Format("{0:D2}:{1:D2}", t.Minutes, t.Seconds)
            End If
        End Get
    End Property
    Public Sub New(gpsD As GPSDevice)
        GPSDevice = gpsD
        GPSDeviceData = New GPSDeviceData()
        With GPSDeviceData
            .AnlgIN = 0
            .AnlgOUT = 0
            .DigIN = "00"
            .DigOUT = "00"
            .SatellitesViewed = 0
            .Speed = 0
            .HDOP = 0
            .Height = 0
            .FixType = "0"
            .Latitude = "000000"
            .Longtitude = "000000"
            .ReceivedDate = "01.01.2011"
            .ReceivedTime = "00:00:00"
            .LoggingCause = 0
            .MessageCode = 0
            .IP = "000.000.000.000"
        End With
        Timer = 0
    End Sub

End Class
