﻿Public Class FrmSettings

    Private Sub OK_Button_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ButOk.Click
        Dim result As Integer

        If txtYellowColorMin.Text.Trim() = String.Empty Then
            ErrorProvider1.SetError(txtYellowColorMin, "Zadejte prosím platné číslo")
            Exit Sub
        ElseIf Not Integer.TryParse(txtYellowColorMin.Text.Trim(), result) OrElse result < 0 Then
            ErrorProvider1.SetError(txtYellowColorMin, "Zadejte prosím platné číslo")
            Exit Sub
        Else
            ErrorProvider1.SetError(txtYellowColorMin, String.Empty)
        End If


        If txtYellowColorSec.Text.Trim() = String.Empty Then
            ErrorProvider1.SetError(txtYellowColorSec, "Zadejte prosím platné číslo")
            Exit Sub
        ElseIf Not Integer.TryParse(txtYellowColorSec.Text.Trim(), result) OrElse result < 0 Then
            ErrorProvider1.SetError(txtYellowColorSec, "Zadejte prosím platné číslo")
            Exit Sub
        Else
            ErrorProvider1.SetError(txtYellowColorSec, String.Empty)
        End If


        If txtRedColorMin.Text.Trim() = String.Empty Then
            ErrorProvider1.SetError(txtRedColorMin, "Zadejte prosím platné číslo")
            Exit Sub
        ElseIf Not Integer.TryParse(txtRedColorMin.Text.Trim(), result) OrElse result < 0 Then
            ErrorProvider1.SetError(txtRedColorMin, "Zadejte prosím platné číslo")
            Exit Sub
        Else
            ErrorProvider1.SetError(txtRedColorMin, String.Empty)
        End If



        If txtRedColorSec.Text.Trim() = String.Empty Then
            ErrorProvider1.SetError(txtRedColorSec, "Zadejte prosím platné číslo")
            Exit Sub
        ElseIf Not Integer.TryParse(txtRedColorSec.Text.Trim(), result) OrElse result < 0 Then
            ErrorProvider1.SetError(txtRedColorSec, "Zadejte prosím platné číslo")
            Exit Sub
        Else
            ErrorProvider1.SetError(txtRedColorSec, String.Empty)
        End If


        My.Settings.YellowColorInterval = Integer.Parse(txtYellowColorMin.Text.Trim()) * 60 + Integer.Parse(txtYellowColorSec.Text)
        My.Settings.RedColorInterval = Integer.Parse(txtRedColorMin.Text.Trim()) * 60 + Integer.Parse(txtRedColorSec.Text)
        My.Settings.Save()
        DialogResult = Windows.Forms.DialogResult.OK
        Close()
    End Sub

    Private Sub Cancel_Button_Click(ByVal sender As System.Object, ByVal e As EventArgs) Handles ButCancel.Click
        DialogResult = Windows.Forms.DialogResult.Cancel
        Close()
    End Sub
    Private Sub FrmSettings_Load(sender As Object, e As EventArgs) Handles Me.Load
        Try
            txtYellowColorMin.Text = (My.Settings.YellowColorInterval \ 60).ToString()
            txtYellowColorSec.Text = My.Settings.YellowColorInterval - (Integer.Parse(txtYellowColorMin.Text) * 60)

            txtRedColorMin.Text = (My.Settings.RedColorInterval \ 60).ToString()
            txtRedColorSec.Text = My.Settings.RedColorInterval - (Integer.Parse(txtRedColorMin.Text) * 60)

        Catch ex As Exception

        End Try
    End Sub

    Private Sub ButReset_Click(sender As System.Object, e As EventArgs) Handles ButReset.Click
        If MessageBox.Show("Chcete určitě obnovit výchozí nastavení ?", "Nastavení", MessageBoxButtons.YesNo, MessageBoxIcon.Question) = MsgBoxResult.Yes Then
            My.Settings.Reset()
            FrmSettings_Load(Nothing, Nothing)
        End If
    End Sub
End Class
