﻿Public Interface IDatabase
    Function GetDeviceList(ownerkey As String) As List(Of GPSDevice)
    Function IsDeviceRegistered(emei As String, deviceType As String) As Boolean
    Sub SetGPSDeviceDataId(gpsDeviceData As GPSDeviceData, deviceType As String)
    Function GetOwner(ownerKey As String) As Owner
    Function IsDeviceOwnedBy(id As Integer, ownerId As Integer) As Boolean
    Function GetDeviceCount(deviceType As String) As Integer
    Sub GetOwnerCalcDistributors(owner As Owner)
    Function GetPicoTrackDeployments(imei As String) As List(Of PicoTrackConfigDeployment)
    Sub ChangeDeploymentState(deploymentId As Integer, status As Integer, response As String)
    Sub ResetDeploymentState(imei As String)
    Sub ResetAllDeploymentState()
End Interface
