﻿Imports GPSConnector.Common

<ServiceContract(CallbackContract:=GetType(IGPSConnectorStatusServiceCallBack))>
Public Interface IGPSConnectorStatusService
    <OperationContract()>
    Function GetDevices(ownerkey As String) As List(Of GPSDevice)
    <OperationContract()>
    Function GetDeviceData(ownerkey As String) As List(Of GPSDeviceData)
    <OperationContract()>
    Function GetLogInfo() As List(Of LogInfo)
    <OperationContract()>
    Function GetLogError() As List(Of LogInfo)
    <OperationContract()>
    Function GetDeviceTypeComponentInfo() As List(Of DeviceTypeComponentInfo)
    <OperationContract()>
    Function GetCustomServices() As List(Of CustomService)
    <OperationContract()>
    Function GetCustomServiceStatus(customService As String) As List(Of CustomServiceStatus)
    <OperationContract()>
    Function Subscribe(onwerkey As String) As Boolean
    <OperationContract()>
    Function Unsubscribe() As Boolean
    <OperationContract()>
    Function GetOwnerInfo(ownerKey As String) As Owner
    <OperationContract()>
    Function Calculate(ownerKey As String, distributorId As Integer, dataDate As Date) As CalculationResult
    <OperationContract()>
    Sub HeartBeatTest()
End Interface
