﻿Imports System.Globalization
Imports GPSConnector.Common

Module Helper
    ''' <summary>
    ''' Translate GPSDevice data into GSloc format and persist it
    ''' </summary>
    ''' <param name="data"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function GPSDeviceDataToGsLoc(data As GPSDeviceData) As GsLoc
        Dim gsloc As GsLoc = New GsLoc()
        With gsloc
            .Datum1 = data.ReceivedDate
            .Cas1 = data.ReceivedTime
            .Datum2 = Trim$(Mid$(data.LoggingTime, 1, 2) & "." & Mid$(data.LoggingTime, 3, 2) & "." & Mid$(data.LoggingTime, 5, 2))
            Dim cas2 = Trim$(Mid$(data.LoggingTime, 7, 6))
            .Cas2 = Trim$(Mid$(cas2, 1, 2) & ":" & Mid$(cas2, 3, 2) & ":" & Mid$(cas2, 5, 2))
            .ID = data.Id
            Select Case data.MessageCode.Trim()
                Case "20", "21"
                    Select Case data.LoggingCause
                        Case "99"
                            .IZ = "2"
                        Case "98"
                            .IZ = "3"
                    End Select
                Case "30", "31"
                    If data.LoggingCause = "6" Then
                        .IZ = "3"
                    End If
            End Select

            If .IZ = String.Empty Then .IZ = "99"

            Dim latitude As String = data.Latitude.Replace(CultureInfo.InvariantCulture.NumberFormat.NumberGroupSeparator, String.Empty).Replace(CultureInfo.InvariantCulture.NumberFormat.NumberDecimalSeparator, String.Empty)
            Dim longitude As String = data.Longtitude.Replace(CultureInfo.InvariantCulture.NumberFormat.NumberGroupSeparator, String.Empty).Replace(CultureInfo.InvariantCulture.NumberFormat.NumberDecimalSeparator, String.Empty)


            ' Latitude
            Dim ltDegr As String = Mid(latitude, 1, 2)
            Dim ltMins As String = CStr(CDbl("0," & Mid(latitude, 3, Len(latitude) - Len(ltDegr))) * 60)

            If (InStr(ltMins, ",") = 0) And (ltMins < 10) Then
                ltMins = "0" & ltMins & ",000"
            End If

            If (InStr(ltMins, ",") = 2) Then
                ltMins = "0" & ltMins
            End If

            .LT = ltDegr & ltMins
            .LT = .LT.Replace(",", "").Trim()

         
            ' Longtitude
            Dim ldDegr As String = Mid(longitude, 1, 2)
            Dim ldMins As String = CStr(CDbl("0," & Mid(longitude, 3, Len(longitude) - Len(ldDegr))) * 60)
            If (InStr(ldMins, ",") = 0) And (ldMins < 10) Then
                ldMins = "0" & ldMins & ",000"
            End If
            If (InStr(ldMins, ",") = 2) Then
                ldMins = "0" & ldMins
            End If
            .LD = ldDegr & ldMins
            .LD = .LD.Replace(",", "").Trim()
            .SP = data.Speed
            .HD = data.Course

            If (data.FixType = 1) Then
                .OK = "0"
            ElseIf (data.FixType = 2) Then
                .OK = "2"
            Else
                .OK = "1"
            End If
            .NS1 = data.SatellitesViewed
            .NS2 = data.SatellitesViewed
            .T1 = "00,0"
            .T2 = "00,0"
            .AI = data.AnlgIN
            .AO = data.AnlgOUT
            .HG = data.Height
            .CZPR = "0"
            .UN = (data.AnlgIN / 10).ToString()
            .guid = data.Guid

        End With

        Return gsloc
    End Function
End Module
