-- ==========================================================
-- Create Stored Procedure sp_gps_device_data_ins
-- ==========================================================
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		Elysee Dagan
-- Create date: 13-10-2012
-- =============================================
IF OBJECT_ID('[dbo].[sp_gps_device_data_ins]') IS NOT NULL 
    BEGIN
        DROP PROCEDURE [dbo].[sp_gps_device_data_ins]
        IF OBJECT_ID('[dbo].[sp_gps_device_data_ins]') IS NOT NULL 
            PRINT '*** FAILED DROPPING PROCEDURE [dbo].[sp_gps_device_data_ins]***'
        ELSE 
            PRINT '*** DROPPED PROCEDURE [dbo].[sp_gps_device_data_ins]****'
    END
go
CREATE PROCEDURE [dbo].[sp_gps_device_data_ins]
    @gps_device_id INT ,
    @received_date DATE ,
    @received_time TIME(0) ,
    @gps_date DATE ,
    @gps_time TIME(0) ,
    @longitude VARCHAR(20) ,
    @latitude VARCHAR(20) ,
    @altitude INT ,
    @speed INT ,
    @course INT ,
    @satelite_in_viewed INT ,
    @analog_in INT ,
    @analog_out INT ,
    @digital_in INT ,
    @digital_out INT ,
    @ip VARCHAR(50) ,
    @exact_received_date DATETIME ,
    @message_code INT ,
    @logging_cause INT
AS 
    BEGIN
        INSERT  INTO [dbo].[gps_device_data]
                ( [gps_device_id] ,
                  [received_date] ,
                  [received_time] ,
                  [gps_date] ,
                  [gps_time] ,
                  [longitude] ,
                  [latitude] ,
                  [altitude] ,
                  [speed] ,
                  [course] ,
                  [satelite_in_viewed] ,
                  [analog_in] ,
                  [analog_out] ,
                  [digital_in] ,
                  [digital_out] ,
                  [ip] ,
                  exact_received_date ,
                  message_code ,
                  logging_cause
                )
        VALUES  ( @gps_device_id ,
                  @received_date ,
                  @received_time ,
                  @gps_date ,
                  @gps_time ,
                  @longitude ,
                  @latitude ,
                  @altitude ,
                  @speed ,
                  @course ,
                  @satelite_in_viewed ,
                  @analog_in ,
                  @analog_out ,
                  @digital_in ,
                  @digital_out ,
                  @ip ,
                  @exact_received_date ,
                  @message_code ,
                  @logging_cause
                )
    END
  
 GO
    GRANT EXEC ON [dbo].[sp_gps_device_data_ins] TO process_role     
 GO

IF OBJECT_ID('[dbo].[sp_gps_device_data_ins]') IS NOT NULL 
    PRINT '*** CREATED PROCEDURE [dbo].[sp_gps_device_data_ins] ***'
ELSE 
    PRINT '*** FAILED CREATING PROCEDURE [dbo].[sp_gps_device_data_ins] ***'
go