-- ==========================================================
-- Create Stored Procedure sp_gps_device_get_all
-- ==========================================================
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		Elysee Dagan
-- Create date: 13-10-2012
-- =============================================
IF OBJECT_ID('[dbo].[sp_gps_device_get_all]') IS NOT NULL 
    BEGIN
        DROP PROCEDURE [dbo].[sp_gps_device_get_all]
        IF OBJECT_ID('[dbo].[sp_gps_device_get_all]') IS NOT NULL 
            PRINT '*** FAILED DROPPING PROCEDURE [dbo].[sp_gps_device_get_all]***'
        ELSE 
            PRINT '*** DROPPED PROCEDURE [dbo].[sp_gps_device_get_all]****'
    END
go
CREATE PROCEDURE [dbo].[sp_gps_device_get_all]
AS 
    BEGIN
    
        SELECT  g.[id] ,
                [imei] ,
                [device_type] ,
                [device_model] ,
                [active] ,
                [serial_number] ,
                [name] ,
                [gps_owner_id] ,
                o.owner_name AS owner_name
        FROM    [dbo].[gps_device] g
                JOIN dbo.gps_device_owner O ON o.id = g.gps_owner_id
        WHERE   active = 1
    
    END

GO

 GRANT EXEC ON [dbo].[sp_gps_device_get_all] TO process_role     

GO

IF OBJECT_ID('[dbo].[sp_gps_device_get_all]') IS NOT NULL 
    PRINT '*** CREATED PROCEDURE [dbo].[sp_gps_device_get_all] ***'
ELSE 
    PRINT '*** FAILED CREATING PROCEDURE [dbo].[sp_gps_device_get_all] ***'
go