﻿Imports System.Globalization

Module Common
    Public Function ConvertFromUnixTimestamp(timestamp As Long, Optional from As DateTime? = Nothing) As DateTime
        If Not from.HasValue Then
            from = New DateTime(1970, 1, 1, 0, 0, 0, 0)
        End If
        Return from.Value.AddSeconds(timestamp)
    End Function
    Public Function ConvertPositionToNumberRepresentation(position As String) As String
        Dim m As String = Math.Truncate(Double.Parse(Right(position, 7).Replace(CultureInfo.InvariantCulture.NumberFormat.NumberDecimalSeparator, String.Empty), CultureInfo.InvariantCulture) / 60).ToString("0000")
        Dim h As Integer = CInt(position.Replace(Right(position, 7), String.Empty))
        Return h.ToString("00") & m
    End Function
    Public Function ConvertHexToInteger(ByVal hexValue As String) As Single

        Try
            Dim iInputIndex As Integer = 0
            Dim iOutputIndex As Integer = 0
            Dim bArray(3) As Byte
            For iInputIndex = 0 To hexValue.Length - 1 Step 2
                bArray(iOutputIndex) = Byte.Parse(hexValue.Chars(iInputIndex) & hexValue.Chars(iInputIndex + 1), Globalization.NumberStyles.HexNumber)
                iOutputIndex += 1
            Next
            Array.Reverse(bArray)
            Return BitConverter.ToSingle(bArray, 0)
        Catch ex As Exception
            Throw New FormatException("The supplied hex value is either empty or in an incorrect format. Use the following format: 00000000", ex)
        End Try
    End Function
End Module
