﻿Imports GPSConnector.Common

Public Class FM2200
    Inherits TeltonikaDevice

    Public Overrides ReadOnly Property CodeId As Integer
        Get
            Return 8
        End Get
    End Property

    Public Overrides Function ParseData(teltonikaDeviceData As TeltonikaDeviceData) As GPSProcessorResult
        Dim result As New GPSProcessorResult
        Dim HexData(teltonikaDeviceData.Data.Length - 4) As String
        Dim j As Integer = 0
        Dim i As Integer
        Dim recCount As Integer = 0
        Dim gpsData As GPSDeviceData
        Dim strtimeStamp As String
        Dim lgTimeStamp As Long
        Dim longititude, latitude, altitude, course, satellites, speed As String


        For i = 2 To teltonikaDeviceData.Data.Length - 2
            If Hex(teltonikaDeviceData.Data(i)).Length = 1 Then
                HexData(j) = "0" & Hex(teltonikaDeviceData.Data(i))
            Else
                HexData(j) = Hex(teltonikaDeviceData.Data(i))
            End If
            j = j + 1
        Next i


        i = 0

        Do
            recCount = recCount + 1
            gpsData = New GPSDeviceData()
            strtimeStamp = String.Empty
            longititude = String.Empty
            latitude = String.Empty
            altitude = String.Empty
            course = String.Empty
            speed = String.Empty


            For k As Integer = 0 To 7
                strtimeStamp = strtimeStamp & HexData(i + k)
            Next
            lgTimeStamp = Convert.ToInt64(strtimeStamp, 16) / 1000
            Dim dt As DateTime = ConvertFromUnixTimestamp(lgTimeStamp)

            gpsData.Imei = teltonikaDeviceData.IMEI
            gpsData.GPSTime = dt.ToString("ddMMyyHHmmss")
            gpsData.LoggingTime = gpsData.GPSTime

            For k As Integer = 9 To 12
                longititude = longititude & HexData(i + k)
            Next

            For k As Integer = 13 To 16
                latitude = latitude & HexData(i + k)
            Next

            For k As Integer = 17 To 18
                altitude = altitude & HexData(i + k)
            Next

            For k As Integer = 19 To 20
                course = course & HexData(i + k)
            Next

            satellites = HexData(i + 21)

            For k As Integer = 22 To 23
                speed = speed & HexData(i + k)
            Next

            gpsData.Longtitude = Convert.ToInt32(longititude, 16)
            gpsData.Latitude = Convert.ToInt32(latitude, 16)
            gpsData.Height = Convert.ToInt32(altitude, 16)
            gpsData.Course = Convert.ToInt32(course, 16)
            gpsData.SatellitesViewed = Convert.ToInt32(satellites, 16)
            gpsData.Speed = Convert.ToInt32(speed, 16)


            gpsData.VDOP = -1
            gpsData.HDOP = -1
            gpsData.Mileage = -1

            If ((gpsData.SatellitesViewed >= 4) And (gpsData.Speed < 240)) Then
                gpsData.FixType = 3
            Else
                gpsData.FixType = 0
            End If

            gpsData.MCC = -1
            gpsData.DigIN = 0
            gpsData.DigOUT = 0
            gpsData.AnlgIN = 0
            gpsData.AnlgOUT = 0
            gpsData.PomAnlgIN = -1
            gpsData.PomAnlgIN = -1
            gpsData.MotionSensor = -1
            gpsData.GPSAccuracy = -1
            gpsData.MessageCode = 20          ' Na tvrdo, Track point=20,98 / Periodic point=20,99 / Alarm point=30,66
            gpsData.LoggingCause = 98

            'Operace s IO
            Dim num_io_bytes_N1 As Integer = Convert.ToInt32(HexData(i + 26), 16) * 2
            Dim num_io_bytes_N2 As Integer = Convert.ToInt32(HexData(i + 26 + num_io_bytes_N1 + 1), 16) * 3
            Dim num_io_bytes_N4 As Integer = Convert.ToInt32(HexData(i + 26 + num_io_bytes_N1 + num_io_bytes_N2 + 1), 16) * 5
            Dim num_io_bytes_N8 As Integer = Convert.ToInt32(HexData(i + 26 + num_io_bytes_N1 + num_io_bytes_N2 + num_io_bytes_N4 + 1), 16) * 9
            Dim num_io_bytes_N As Integer = num_io_bytes_N1 + num_io_bytes_N2 + num_io_bytes_N4 + num_io_bytes_N8

            i = i + 26 + 4 + num_io_bytes_N
            result.GPSDeviceDataList.Add(gpsData)

        Loop Until recCount = teltonikaDeviceData.NumberOfRecord

        result.Success = True
        result.BackMessages.Add(New Byte() {0, 0, 0, teltonikaDeviceData.NumberOfRecord})
        Return result
    End Function
End Class

