﻿Public Enum PicoTrackMessageCodeType
    BasicConfiguration
    LoggingData
    EventData
    Geofence
    IPParameterConfiguration
    StatusMessage
    StatusMessageRequest
    NetworkMessage
    NetworkMessageRequest
End Enum

Public Class PicoTrackMessageCode
    Private _PicoTrackMessageCodeType As PicoTrackMessageCodeType
    Private _code As String
    Private _codeAckReq As String
    Private _codeAckResp As String
    Private Shared ReadOnly codes As New List(Of PicoTrackMessageCode)

    Shared Sub New()
        codes.Add(
            New PicoTrackMessageCode() With {.Code = "10", .CodeAckReq = "11", .CodeAckResp = "14", .PicoTrackMessageCodeType = PicoTrackMessageCodeType.BasicConfiguration})
        codes.Add(
            New PicoTrackMessageCode() With {.Code = "20", .CodeAckReq = "21", .CodeAckResp = "24", .PicoTrackMessageCodeType = PicoTrackMessageCodeType.LoggingData})

        codes.Add(
           New PicoTrackMessageCode() With {.Code = "30", .CodeAckReq = "31", .CodeAckResp = "34", .PicoTrackMessageCodeType = PicoTrackMessageCodeType.EventData})

        codes.Add(
          New PicoTrackMessageCode() With {.Code = "A0", .CodeAckReq = "A1", .CodeAckResp = "A4", .PicoTrackMessageCodeType = PicoTrackMessageCodeType.Geofence})

        codes.Add(
          New PicoTrackMessageCode() With {.Code = "B0", .CodeAckReq = "B1", .CodeAckResp = "B4", .PicoTrackMessageCodeType = PicoTrackMessageCodeType.IPParameterConfiguration})
       codes.Add(   New PicoTrackMessageCode() With {.Code = "42", .CodeAckReq = "42", .CodeAckResp = "44", .PicoTrackMessageCodeType = PicoTrackMessageCodeType.StatusMessageRequest})

        codes.Add(
         New PicoTrackMessageCode() With {.Code = "40", .CodeAckReq = "41", .CodeAckResp = "44", .PicoTrackMessageCodeType = PicoTrackMessageCodeType.StatusMessage})


        codes.Add(
            New PicoTrackMessageCode() With {.Code = "72", .CodeAckReq = "72", .CodeAckResp = "74", .PicoTrackMessageCodeType = PicoTrackMessageCodeType.NetworkMessageRequest})

        codes.Add(
        New PicoTrackMessageCode() With {.Code = "70", .CodeAckReq = "71", .CodeAckResp = "74", .PicoTrackMessageCodeType = PicoTrackMessageCodeType.NetworkMessage})

    End Sub
    Public Shared Function GetMessageCode(msgCode As String) As PicoTrackMessageCode
        Return codes.FirstOrDefault(Function(c) c.Code = msgCode OrElse c.CodeAckReq = msgCode OrElse c.CodeAckResp = msgCode)
    End Function

    Public Property PicoTrackMessageCodeType As PicoTrackMessageCodeType
        Get
            Return _PicoTrackMessageCodeType
        End Get
        Private Set(value As PicoTrackMessageCodeType)
            _PicoTrackMessageCodeType = value
        End Set
    End Property

    Public Property Code As String
        Get
            Return _code
        End Get
        Private Set(value As String)
            _code = value
        End Set
    End Property

    Public Property CodeAckReq As String
        Get
            Return _codeAckReq
        End Get
        Private Set(value As String)
            _codeAckReq = value
        End Set
    End Property

    Public Property CodeAckResp As String
        Get
            Return _codeAckResp
        End Get
        Private Set(value As String)
            _codeAckResp = value
        End Set
    End Property
End Class
