﻿Imports System.Globalization
Imports GPSConnector.Common
Public Class Watch
    Implements IGPSProcessor

    Public Function ProcessData(rawData As String, uniqueKey As String) As GPSProcessorResult Implements IGPSProcessor.ProcessData
        Dim result As GPSProcessorResult = New GPSProcessorResult()
        Dim gpsDeviceData As GPSDeviceData
        Dim gpsDataList As String() = rawData.Split(New String() {"###"}, StringSplitOptions.RemoveEmptyEntries)
        Dim splitData As String()

        For Each s As String In gpsDataList
            gpsDeviceData = New GPSDeviceData()
            splitData = s.Trim().Split(New String() {"##", "#"}, StringSplitOptions.RemoveEmptyEntries)
            If FillData(gpsDeviceData, splitData) Then
                result.GPSDeviceDataList.Add(gpsDeviceData)
            End If
        Next
        result.Success = True
        Return result
    End Function

    Public Function ProcessData(ByVal rawData As Byte(), ByVal uniqueKey As String) As GPSProcessorResult Implements IGPSProcessor.ProcessData
        Throw New NotImplementedException()
    End Function

    Public Sub Cleanup(ByVal uniqueKey As String) Implements IGPSProcessor.Cleanup

    End Sub

    Private Function FillData(gpsDeviceData As GPSDeviceData, splitdata As String()) As Boolean
        Try
            Dim positions() As String = splitdata(6).Split(",")
            With gpsDeviceData
                .Imei = splitdata(0)
                .LoggingTime = splitdata(7) & splitdata(8)
                .GPSTime = splitdata(7) & splitdata(8)
                .Longtitude = ConvertPositionToNumberRepresentation(positions(0))
                .Latitude = ConvertPositionToNumberRepresentation(positions(2))
                .Course = CInt(positions(5))
                .MessageCode = 20
                .LoggingCause = 99
                If Not String.IsNullOrEmpty(.Latitude) AndAlso Not String.IsNullOrEmpty(.Longtitude) Then
                    .FixType = 3
                Else
                    .FixType = 1
                End If

                .SatellitesViewed = 7
            End With
            Try
                gpsDeviceData.Speed = Math.Round(Double.Parse(positions(4), CultureInfo.InvariantCulture))
            Catch ex As Exception
                gpsDeviceData.Speed = 0
            End Try
            Return True
        Catch ex As Exception
            Return False
        End Try
    End Function
   
End Class
