﻿Imports System.Net.Sockets
Imports System.Text
Public Class Form1
    Private WithEvents tcpclient As TcpClient
    Dim WithEvents stream As NetworkStream
    Dim count As Integer
    Dim myReadBuffer(1024) As Byte
    Private Sub ButSend_Click(sender As System.Object, e As System.EventArgs) Handles ButSend.Click
        Try
            ButSend.Enabled = False
            ButSEND100.Enabled = False
            send()
        Catch ex As Exception
            txtLog.Text += "Error(ButSend_Click): " + ex.Message
        Finally
            ButSend.Enabled = True
            ButSEND100.Enabled = True
            If Not chkKeepConnection.Checked Then
                If Not tcpclient Is Nothing AndAlso tcpclient.Connected Then
                    tcpclient.Close()
                    stream.Close()
                    tcpclient = Nothing
                End If
            End If
        End Try
    End Sub
    Private Sub Send()
        If tcpclient Is Nothing OrElse Not tcpclient.Connected Then
            tcpclient = New TcpClient()
            tcpclient.Connect(txtServer.Text.Trim(), CInt(txtPort.Text.Trim()))
            stream = tcpclient.GetStream()
            BeginStreamRead()
        End If
        Dim msg As String = txtMsg.Text.Trim()
        Dim data As Byte()

        If radCRLF.Checked Then
            msg += vbCrLf
            data = System.Text.Encoding.ASCII.GetBytes(msg)
        ElseIf radZeroByte.Checked Then
            data = System.Text.Encoding.ASCII.GetBytes(msg)
            ReDim Preserve data(data.Length)
            data(data.Length - 1) = CByte(0)
        Else
            data = System.Text.Encoding.ASCII.GetBytes(msg)
        End If
        ' Send the message to the connected TcpServer. 
        stream.Write(data, 0, data.Length)
        count += 1
        txtLog.Text += String.Format("Sent : {0} > " + txtMsg.Text + vbCrLf, count)
    End Sub

    Private Sub BeginStreamRead()
       stream.BeginRead(myReadBuffer, 0, myReadBuffer.Length, New AsyncCallback(AddressOf ReadCallBack), stream)
    End Sub

    Private Sub Form1_Load(sender As Object, e As System.EventArgs) Handles Me.Load
        cboTemplate.Items.Add("Pico Track Logging Data|ID20IMEI99,030408145540,0,030408065431,115867,480333,3,0,192,14,,,587,100114124,,00,00,180,0")
        cboTemplate.Items.Add("Pico Track Event Data|ID30IMEI06,130310103227,0,130310103227,135629,497500,3,121,249,7,,,351,618395,,00,00,154,0")
        cboTemplate.Items.Add(("Pico Track Geofence Ack Message |IDA4IMEI"))
        cboTemplate.Items.Add(("Pico Track Basic Configuration |ID14IMEI"))
        cboTemplate.SelectedIndex = 0
    End Sub

    Private Sub butCopy_Click(sender As System.Object, e As System.EventArgs) Handles butCopy.Click
        txtMsg.Text = cboTemplate.SelectedItem.ToString().Split("|")(1).Replace("IMEI", txtIMEI.Text).Replace("ID", txtMsgId.Text)
    End Sub

    Private Sub Butclear_Click(sender As System.Object, e As System.EventArgs) Handles Butclear.Click
        txtMsg.Text = String.Empty
        count = 0
    End Sub

    Private Sub ButSEND100_Click(sender As System.Object, e As System.EventArgs) Handles ButSEND100.Click
        Try
            ButSend.Enabled = False
            ButSEND100.Enabled = False
            For i As Integer = 1 To 100
                Send()
            Next

        Catch ex As Exception
            txtLog.Text += "Error: " + ex.Message
        Finally
            ButSend.Enabled = True
            ButSEND100.Enabled = False
            If Not chkKeepConnection.Checked Then
                If Not tcpclient Is Nothing AndAlso tcpclient.Connected Then
                    tcpclient.Close()
                    stream.Close()
                    tcpclient = Nothing
                End If
            End If
        End Try
    End Sub

    Private Sub ReadCallBack(result As IAsyncResult)
        Try
            Dim byteLength = stream.EndRead(result)
            Dim nBytes() As Byte
            Dim data As String
            If byteLength > 0 Then
                ReDim nBytes(byteLength - 1)
                Array.Copy(myReadBuffer, nBytes, byteLength)
                data = System.Text.Encoding.ASCII.GetString(nBytes)
                If Not txtReceivedMsg.InvokeRequired Then
                    txtReceivedMsg.Text += String.Format("Received : {0} > ", data & vbCrLf)
                Else
                    txtReceivedMsg.Invoke(Sub() txtReceivedMsg.Text += "Received : " & data & Environment.NewLine)
                End If
                stream.Flush()
                stream.BeginRead(myReadBuffer, 0, myReadBuffer.Length, New AsyncCallback(AddressOf ReadCallBack), stream)
            End If

        Catch ex As Exception
            txtLog.Text += "Error(ReadCallBack): " + ex.Message
        End Try

    End Sub

End Class
